//---------------------------------------------------------------
// Fichero:  diferenciaBA.asy
// Objetivo: Representar el conjunto B-A
// Fecha:    X.21.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// El conjunto universal
path U=box((0,0),(3,2));
draw(U);

// Los conjuntos A y B
path A=shift(1,1)*scale(0.85,0.67)*rotate(180)*unitcircle;
path B=shift(2,1)*scale(0.85,0.67)*rotate(180)*unitcircle;

// Los valores de los cortes de A y B
real[][] Corte=intersections(A,B);
real a1=Corte[0][0]-0.1;
real a2=Corte[1][0]+0.1;
real b1=Corte[0][1]-0.1;
real b2=Corte[1][1]+0.1;

// Las partes de cada conjunto que nos interesan
path ParteA=subpath(A, a1, a2);
path ParteB=subpath(B, b1, b2);

// La diferencia de conjuntos
path Diferencia=buildcycle(ParteA,ParteB);
filldraw(Diferencia,gray,black);
