//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Mostrar el ejemplo 2
// Fecha:    J.22.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(2);

// Un rectángulo
path Rectangulo=box((-1,-0.7),(1,0.7));

// Lo repetimos
path[] Replica;
real Hor=2, Ver=1;
Replica[0]=Rectangulo;
Replica[1]=shift(Hor,Ver)*Rectangulo;
Replica[2]=shift(Hor,-Ver)*Rectangulo;
Replica[3]=shift(-Hor,Ver)*Rectangulo;
Replica[4]=shift(-Hor,-Ver)*Rectangulo;

// El contorno
for (int i=0 ; i<5 ; ++i)
    { draw(Replica[i]);}

// El relleno
for (int i=0 ; i<5 ; ++i)
    { fill(Replica[i],gray);}
