//---------------------------------------------------------------
// Fichero:  semirrecta3b.asy
// Objetivo: Representar la semirrecta (←,a) de la segunda forma
// Fecha:    V.23.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1.5);

// El eje de abscisas
draw((0,0) -- (4,0));

// Los puntos
pair A=(0.5,0);
pair B=(3.5,0);

// El extremo
dot(B,5pt+black); dot(B,3pt+white);

// La letra
pen FormatoTexto=fontsize(10pt)+black+Helvetica(series="m",shape="n");
label("a",B,3S,FormatoTexto);

// La flecha
pen FormatoFlecha=fontsize(14pt)+blue;
label("$\longleftarrow$",A,2N+W,FormatoFlecha);

// Marcamos el intervalo
for (int i=-3 ; i<14 ; ++i)
    { draw((0.6+0.2*i,-0.075)--(0.8+0.2*i,0.075),1bp+blue); }
