//---------------------------------------------------------------
// Fichero:  resolucion2.asy
// Objetivo: Mostrar la resolución 2
// Fecha:    D.25.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Los extremos de los intervalos
int a1=-2, a2=4, b1=1, b2=5;

// El eje de abscisas
draw((a1-0.5,0) -- (b2+0.5,0));
pen FormatoPunto=3bp+black;
dot((-1,0),FormatoPunto);
dot((0,0),FormatoPunto);
dot((2,0),FormatoPunto);
dot((3,0),FormatoPunto);

// Tipo de letra
pen Helvetica=Helvetica(series="b",shape="n");

// Colores
pen Azul=mediumblue, Naranja=orange;

// Los puntos
pair A1=(a1,0), A2=(a2,0);
pair B1=(b1,0), B2=(b2,0);

// Las marcas de los extremos
label("[",A1,Helvetica);
label("]",A2,Helvetica);
label("(",B1,Helvetica);
label(")",B2,Helvetica);

// Los números de los extremos
pen FormatoTexto=fontsize(10pt)+Helvetica;
label("--2",A1,4S,FormatoTexto+Azul);
label(string(a2),A2,4S,FormatoTexto+Azul);
label(string(b1),B1,4N,FormatoTexto+Naranja);
label(string(b2),B2,4N,FormatoTexto+Naranja);

// Los intervalos
real Sep=0.25;
draw((a1,-Sep)--(a2,-Sep),2bp+Azul);
dot((a1,-Sep),4bp+Azul);
dot((a2,-Sep),4bp+Azul);
draw((b1,Sep)--(b2,Sep),2bp+Naranja);
dot((b1,Sep),4bp+Naranja);
dot((b1,Sep),2bp+white);
dot((b2,Sep),4bp+Naranja);
dot((b2,Sep),2bp+white);
