//---------------------------------------------------------------
// Fichero:  resolucion2.asy
// Objetivo: Mostrar la resolución 2
// Fecha:    D.25.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Los extremos del intervalo
int a1=0, a2=1;

// El eje de abscisas
draw((-0.1,0) -- (1.1,0));
pen FormatoLinea=1bp+black;
draw((0,-0.01)--(0,0.01),FormatoLinea);
draw((1,-0.01)--(1,0.01),FormatoLinea);

// Tipo de letra
pen Helvetica=Helvetica(series="b",shape="n");

// Colores
pen Azul=mediumblue, Naranja=orange;

// Los puntos
pair A1=(a1,0), A2=(a2,0);

// Los números de los extremos
pen FormatoTexto=fontsize(10pt)+Helvetica;
label(string(a1),A1,4S,FormatoTexto+Azul);
label(string(a2),A2,4S,FormatoTexto+Azul);
label("0",(0,0),4N,FormatoTexto+Naranja);

// Los datos
real Sep=0.025;
draw((a1,-Sep)--(a2,-Sep),2bp+Azul);
dot((a1,-Sep),4bp+Azul);
dot((a1,-Sep),2bp+white);
dot((a2,-Sep),4bp+Azul);
dot((a2,-Sep),2bp+white);
dot((0,Sep),4bp+Naranja);
