//---------------------------------------------------------------
// Fichero:  cuadrilateroB.asy
// Objetivo: Mostrar un cuadrilátero
// Fecha:    V.8.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Rejilla
add(grid(9,4,0.5bp+gray));

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(2,1), B=(6,1), C=(8,3), D=(1,2);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Los vértices
pen Formato=3bp+black;
dot(A,Formato);
dot(B,Formato);
dot(C,Formato);
dot(D,Formato);
