//---------------------------------------------------------------
// Fichero:  estrella2.asy
// Objetivo: Segundo paso para generar la estrella tartésica
// Fecha:    V.8.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Un cuadrado
path Cuadrado1=box((-1,-1),(1,1));
draw(Cuadrado1);

// Lo giramos
path Cuadrado2=rotate(45)*Cuadrado1;
draw(Cuadrado2,blue);

// Mostramos el giro
pair T=(0,0), A=(-1,1), B=(0,sqrt(2));
draw(T--A,deepgreen);
draw(T--B,deepgreen);
markangle(radius=3.5mm, B, T, A, 0.5bp+deepgreen);
label("$45^\circ$", (-0.2,0.5), deepgreen+fontsize(4pt));

