//---------------------------------------------------------------
// Fichero:  triangulo.asy
// Objetivo: Mostrar una construcción con un triángulo
// Fecha:    V.8.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,sqrt(3)/2), B=(-0.5,0), C=(0.5,0);

// Los puntos medios
pair M=(A+B)/2, NN=(A+C)/2;

// El punto de corte
pair P=intersectionpoint(B--NN,C--M);

// Las líneas
draw(B--NN^^C--M);
draw(A--B--C--cycle);

// El triángulo pequeño
filldraw(M--NN--P--cycle,gray,black);

// Los nombres
pen Formato=blue+fontsize(6pt)+Bookman(series="b",shape="n");;
label("A", A, N, Formato);
label("B", B, W, Formato);
label("C", C, E, Formato);
label("M", M, W, Formato);
label("N", NN, E, Formato);
label("P", P, S, Formato);
