//---------------------------------------------------------------
// Fichero:  correlaciones.asy
// Objetivo: Calcular todas las correlaciones
// Fecha:    D.27.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(18cm);

// Grosor de las líneas
defaultpen(1);

// Los nombres de las pruebas
string[] Nom={"100 mv","Altura","Peso","200 m","Longitud","Jabalina","800 m"};

// Hay 7 pruebas y 17 atletas
int NumPr=7, NumAt=17;

// Leemos los datos
file Archivo=input("datos.txt");
string[] Dato=Archivo.word();

// Ordenamos los datos
real[][] Prueba = new real[NumPr][NumAt];
int k=0;
string Tmp;
for ( int Atleta=0 ; Atleta<NumAt ; ++Atleta )
    {
    for ( int i=0 ; i<=NumPr ; ++i )
        {
        // Leemos un dato como cadena
        Tmp=Dato[k]; ++k;
        // Si i==0, es el nombre del atleta y no lo necesitamos
        if ( i!=0 )
            {
            // Si i==NumPr, es la marca de 800 m y se pasa a segundos
            if ( i==NumPr )
                {
                string[] MinSeg=split(Tmp,":");
                real Min=(real)MinSeg[0];
                real Seg=(real)MinSeg[1];
                Prueba[i-1][Atleta]=60*Min+Seg;
                }
            else
                { Prueba[i-1][Atleta]=(real)Tmp; }
            }
        }
    }

// Las operaciones preparatorias para cada prueba
real[] Media = new real[NumPr];
real[] DesvTip = new real[NumPr];
real Suma, Suma2;
for ( int i=0 ; i<NumPr ; ++i )
    {
    Suma=0;
    Suma2=0;
    for ( int j=0 ; j<NumAt ; ++j )
        {
        Suma += Prueba[i][j];
        Suma2 += Prueba[i][j]^2;
        }
    Media[i]=Suma/NumAt;
    DesvTip[i]=sqrt(Suma2/NumAt-Media[i]^2);
    }

// Función que calcula el coeficiente de correlación de dos pruebas
string Correlacion(int i, int j)
    {
    // La suma de los productos
    real SumaProd=0;
    for ( int k=0 ; k<NumAt ; ++k )
        { SumaProd += Prueba[i][k]*Prueba[j][k]; }

    // La covarianza
    real Covarianza=SumaProd/NumAt-Media[i]*Media[j];

    // El coeficiente de correlación
    real Coeficiente=Covarianza/(DesvTip[i]*DesvTip[j]);

    // Lo pasamos a dos decimales
    int Redondeado=round(100*Coeficiente);
    Coeficiente=Redondeado/100;

    // Lo devolvemos como cadena
    return (format("%#.2f", Coeficiente));
    }

// El rombo con la correlación
real a=1.5, b=1;
path Rombo=(a,0)--(0,b)--(-a,0)--(0,-b)--cycle;

// Todos los rombos
for (int i=1 ; i<NumPr ; ++i)
    {
    for (int j=0 ; j<i ; ++j)
        {
        pair Pos=((i+j)*a,(i-j)*b);
        draw(shift(Pos)*Rombo);
        label(Correlacion(i,j),Pos,fontsize(14pt));
        }
    }

// Los nombres
pen FT=fontsize(14pt);
for (int i=1 ; i<NumPr ; ++i)
    { label(rotate(-38)*Nom[i],align=left,(a*(i-0.5),b*(i+1)),FT); }
for (int i=0 ; i<NumPr-1 ; ++i)
    { label(rotate(38)*Nom[i],align=right,(a*(i+6.5),b*((6-i)+1)),FT); }

