//---------------------------------------------------------------
// Fichero:  grafica1.asy
// Objetivo: Mostrar la gráfica 1
// Fecha:    V.11.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 9, Ymin = 0, Ymax = 13, Extra = 0.25;

// Definición de los puntos
pair[] P={(6,5), (5,2), (4,4), (2,6), (9,2), (8,5), (7,10), (6,13),
          (5,1), (6,4), (2,4), (1,5)};

// Grosor de las líneas
defaultpen(1);

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis("Goles en contra", ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis("Goles a favor", xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos
for ( int i=0 ; i<P.length ; ++i )
    { dot(P[i],3bp+deepgreen); }
