//---------------------------------------------------------------
// Fichero:  anscombe4.asy
// Objetivo: Mostrar el cuarto conjunto de Anscombe
// Fecha:    V.25.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 19, Ymin = 0, Ymax = 13, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=5, step=1, NoZero, Size=0.25mm, size=0.15mm,
                           pTick=black);

// Formato de texto de los dos ejes
pen FormatoTexto = black+fontsize(5pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), black);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), black);

// Definición de los puntos
pair[] P={(8,6.58), (8,5.76), (8,7.71), (8,8.84), (8,8.47), (8,7.04),
          (8,5.25), (19,12.5), (8,5.56), (8,7.91), (8,6.89)};

// Número de datos
int n=11;

// Las sumas estadisticas
real SumaX=0, SumaY=0, SumaX2=0, SumaXY=0;
for ( int i=0 ; i<n ; ++i )
    {
    SumaX += P[i].x;
    SumaY += P[i].y;
    SumaX2 += (P[i].x)^2;
    SumaXY += (P[i].x)*(P[i].y);
    }

// El centro de gravedad
real MediaX=SumaX/n;
real MediaY=SumaY/n;
pair CG=(MediaX,MediaY);

// El coeficiente de regresión
real CR=(SumaXY/n-MediaX*MediaY)/(SumaX2/n-MediaX^2);

// La recta de regresión
pair V=unit((1,CR)), A=CG-9V, B=CG+9V;
path RR=A -- B;
draw(RR,blue);

// Dibujamos los puntos
for ( int i=0 ; i<n ; ++i )
    { dot(P[i],3bp+red); }

// El centro de gravedad
dot(CG,3bp+deepgreen);
