//---------------------------------------------------------------
// Fichero:  exponencial.asy
// Objetivo: Ilustrar la interpolación exponencial
// Fecha:    V.25.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 10, Ymin = 0, Ymax = 6, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra),gray);
draw((Xmin-Extra,0) -- (Xmax+Extra,0),gray);

// Iniciamos el generador de números aleatorios
srand(3);

// La función
real F(real x) { return (1.2^x); }

// Los puntos
real x, y, var;
for ( int i=0 ; i<18 ; ++i )
    {
    // La abscisa
    x=(i/2+1)+0.3*(unitrand()-0.5);

    // La ordenada
    var=(unitrand()+0.8)/2 * (unitrand()>0.5 ? 1 : -1);
    y=F(x)+var;

    // El punto
    dot((x,y),3bp+deepgreen);
    }

// La gráfica
path Grafica=graph(F,Xmin+Extra,Xmax-Extra,n=200);
draw(Grafica);
