//---------------------------------------------------------------
// Fichero:  cc-medio.asy
// Objetivo: Ilustrar las rectas de regresión con correlación media
// Fecha:    L.28.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 9, Ymin = 0, Ymax = 4, Extra = 0.5;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra),gray);
draw((Xmin-Extra,0) -- (Xmax+Extra,0),gray);

// Iniciamos el generador de números aleatorios
srand(1);

// Generamos los puntos
real x, y, var;
pair[] P;
for ( int i=0 ; i<17 ; ++i )
    {
    // La abscisa
    x=(i/2+1)+0.3*(unitrand()-0.5);

    // La ordenada
    var=(unitrand()+1) * (unitrand()>0.5 ? 1 : -1);
    if ( var<0 )  { var /= 3; }
    y=0.1*(i/2+0.1)+1+var;

    // El punto
    P[i]=(x,y);
    }

// Número de datos
int n=P.length;

// Las sumas estadisticas
real SumaX=0, SumaY=0, SumaX2=0, SumaY2=0, SumaXY=0;
for ( int i=0 ; i<n ; ++i )
    {
    SumaX += P[i].x;
    SumaY += P[i].y;
    SumaX2 += (P[i].x)^2;
    SumaY2 += (P[i].y)^2;
    SumaXY += (P[i].x)*(P[i].y);
    }

// El centro de gravedad
real MediaX=SumaX/n;
real MediaY=SumaY/n;
pair CG=(MediaX,MediaY);

// Una recta de regresión
real CR=(SumaXY/n-MediaX*MediaY)/(SumaX2/n-MediaX^2);
pair V=unit((1,CR)), A=CG-5V, B=CG+4.5V;
path RR=A -- B;
draw(RR);

// La otra recta de regresión
real CR=(SumaY2/n-MediaY^2)/(SumaXY/n-MediaX*MediaY);
pair V=unit((1,CR)), A=CG-4V, B=CG+3.75V;
path RR=A -- B;
draw(RR,blue);

// Dibujamos los puntos
for ( int i=0 ; i<n ; ++i )
    { dot(P[i],3bp+deepgreen); }

// El centro de gravedad
filldraw(circle(CG,0.1),white,gray);

// El coeficiente de correlación con dos decimales
real Covarianza=SumaXY/n-MediaX*MediaY;
real Coeficiente=Covarianza/sqrt((SumaX2/n-MediaX^2)*(SumaY2/n-MediaY^2));
int Redondeado=round(100*Coeficiente);
Coeficiente=Redondeado/100;
string Texto=format("%#.2f", Coeficiente);
label("$\rho="+Texto+"$",(Xmax+Extra,0.5),align=left,fontsize(10pt));
