//---------------------------------------------------------------
// Fichero:  ajedrez.asy
// Objetivo: Mostrar un tablero de ajedrez con datos
// Fecha:    V.1.8.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(0.5);

// El tablero
string Nom[] = {'a','b','c','d','e','f','g','h'};
pen Formato = fontsize(8pt)+Helvetica(series="m",shape="n");
pen Color;
for ( int i=0 ; i<8 ; ++i )
    {
    // Los nombres de las filas y columnas
    label(Nom[i],(i+0.5,-0.85),N,Formato);
    label(string(i+1),(-0.5,i+0.5),Formato);

    // Los escaques
    for ( int j=0 ; j<8 ; ++j  )
        {
        if ( (i+j)%2 == 1 )
            { Color=white; }
        else
            { Color=mediumgray; }
        filldraw(box((i,j),(i+1,j+1)),Color,black);
        }
    }
draw(box((0,0),(8,8)),black+1bp);

// Un camino válido
path Camino=(0.5,0.5)--(0.5,3.5)--(5.5,3.5)--(5.5,6.5)--(7.5,6.5)--(7.5,7.5);
draw(Camino,deepgreen+2bp);

// Las posiciones inicial y final
fill(box((0.25,0.25),(0.75,0.75)),blue);
fill(box((7.25,7.25),(7.75,7.75)),blue);

// La posición intermedia
fill(box((3.25,3.25),(3.75,3.75)),red);
