//---------------------------------------------------------------
// Fichero:  bandera.asy
// Objetivo: Dar varios ejemplos de bandera
// Fecha:    M.5.8.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(17cm);

// Colores
pen[] Color={blue, heavygreen, red, black};

// Dimensiones
int Anchura=5, Altura=3;

// Iniciamos el generador de números aleatorios
srand(3);

// Las banderas
int Base=0;
for ( int i=0 ; i<10 ; ++i )
    {
    Base += Anchura+1;
    // Los rectángulos
    fill(box((Base,0),(Base+Anchura,Altura/3)),Color[floor(4*unitrand())]);
    fill(box((Base,Altura/3),(Base+Anchura,2*Altura/3)),Color[floor(4*unitrand())]);
    fill(box((Base,2*Altura/3),(Base+Anchura,Altura)),Color[floor(4*unitrand())]);
    }
