//---------------------------------------------------------------
// Fichero:  canicas.asy
// Objetivo: Representar el cilindro y las canicas
// Fecha:    M.5.8.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// El centro de la circunferencia
pair T=(0,0);

// La circunferencia
draw(circle(T,1));

// Los radios
for ( int i=0 ; i<8 ; ++i )
    { draw(T -- dir(i*45)); }

// Las canicas
for ( int i=0 ; i<5 ; ++i )
    { fill(circle(0.7*dir(i*45+22.5),0.15),blue); }
