//---------------------------------------------------------------
// Fichero:  cuadrilatero.asy
// Objetivo: Representar varios cuadriláteros
// Fecha:    M.5.8.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(17cm);

// Grosor de las líneas
defaultpen(1);

// Tenemos varias figuras
int NumFig=5, Sep=5;

// Los vértices de cada cuadrilátero
int Dato[]={1,2,3,4,   0,3,5,6,   0,2,3,6,   0,2,4,6,   4,5,1,2};

// Los nombres de los vértices
string Nombre[]={'A','B','C','D','E','F','G'};

// Repetimos la figura
pen FT=fontsize(9pt)+Helvetica(series="b",shape="n");
pen Color=black;
real Ang=360/7;
transform Mov;
pair Pos, V0, V1, V2, V3;
for ( int k=0 ; k<NumFig ; ++k )
    {
    Color=black;
    if ( k==2 )
        { Color=blue; }
    Mov=shift(k*Sep,0);
    V0=Mov*(dir(Ang*Dato[4k+0]));
    V1=Mov*(dir(Ang*Dato[4k+1]));
    V2=Mov*(dir(Ang*Dato[4k+2]));
    V3=Mov*(dir(Ang*Dato[4k+3]));
    draw(V0 -- V1 -- V2 -- V3 -- cycle,Color);
    draw(Mov*unitcircle,lightgreen);
    for ( int i=0 ; i<7 ; ++i )
        {
        Pos=Mov*(dir(Ang*i));
        dot(Pos,3bp+red);
        label(Nombre[i],Mov*(1.5*dir(Ang*i)),FT);
        }
    }
