//---------------------------------------------------------------
// Fichero:  interseccion.asy
// Objetivo: Representar la intersección de sucesos
// Fecha:    M.19.8.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// La elipse general
path Elipse=scale(4,3)*unitcircle;

// El espacio muestral
int MaxX=8, MaxY=6;
draw(box((0,0),(MaxX,MaxY)));
for ( int i=1 ; i<MaxX ; ++i ) {
for ( int j=1 ; j<MaxY ; ++j ) {
    dot((i,j), 3bp+red);
    }}

// La línea del suceso A
draw((0.5,2.5) -- (4.5,2.5) -- (4.5,5.5) -- (0.5,5.5) -- cycle, blue);

// La línea del suceso B
draw((2.5,0.5) -- (6.5,0.5) -- (6.5,4.5) -- (2.5,4.5) -- cycle, orange);

// La línea del suceso A∩B
draw((2.75,2.75) -- (4.25,2.75) -- (4.25,4.25) -- (2.75,4.25) -- cycle,
      1.5bp+deepgreen);
