//---------------------------------------------------------------
// Fichero:  cuadrado.asy
// Objetivo: Ilustrar el problema del cuadrado
// Fecha:    X.7.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definimos los puntos del problema
pair S=(0,0), T=(3,0), R=(0,3), U=(3,3), W=(2,2);

// Los cuadrados menores
fill(box(S,W),gray);
fill(box(U,W),gray);

// El cuadrado mayor
draw(box(S,U),black);

// Los puntos
pen FormatoPunto = 3bp+black;
dot(S, FormatoPunto);
dot(T, FormatoPunto);
dot(R, FormatoPunto);
dot(U, FormatoPunto);
dot(W, FormatoPunto);
pen FormatoTexto = black+fontsize(12pt);
label("S",S,SW,FormatoTexto);
label("T",T,SE,FormatoTexto);
label("R",R,NW,FormatoTexto);
label("U",U,NE,FormatoTexto);
label("W",W,NW,FormatoTexto);
