//---------------------------------------------------------------
// Fichero:  enunciado2izq.asy
// Objetivo: Mostrar la ilustración izquierda del enunciado 2
// Fecha:    M.10.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
pair A=(0,0), B=(34,0), C=(55,0), D=(55,13), E=(55,21), F=(34,13);

// Las piezas
filldraw((A -- B -- F -- cycle),mediumred,black);
filldraw((B -- C -- D -- F -- cycle),mediumgreen,black);
filldraw((D -- E -- F -- cycle),mediumblue,black);

// Las superficies de las piezas
pen FormatoTexto=Helvetica(series="m",shape="n")+fontsize(6pt);
pen ColorFondo=lightgray;
real r=1.8;

pair pos=(21,4);
fill(circle(pos,r),ColorFondo);
label("221",pos,FormatoTexto);

pair pos=(50,16);
fill(circle(pos,r),ColorFondo);
label("84",pos,FormatoTexto);

pair pos=(44.5,6.5);
fill(circle(pos,r),ColorFondo);
label("273",pos,FormatoTexto);

// Las dimensiones de los lados
real S1=1.5, S2=0.5;
draw(A+(S2,-S1) -- B+(-S2,-S1), gray);
label("34",(17,0)+(0,-2*S1),FormatoTexto);
draw(B+(S2,-S1) -- C+(-S2,-S1), gray);
label("21",(44.5,0)+(0,-2*S1),FormatoTexto);
draw(C+(S1,S2) -- D+(S1,-S2), gray);
label("13",(55,6.5)+(2*S1,0),FormatoTexto);
draw(D+(S1,S2) -- E+(S1,-S2), gray);
label("8",(55,17)+(2*S1,0),FormatoTexto);
