//---------------------------------------------------------------
// Fichero:  cuadrado.asy
// Objetivo: Representar el problema del cuadrado
// Fecha:    M.24.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
pair A=(0,0), B=(1,0), C=(1,1), D=(0,1), M=(B+C)/2;
pair P=intersectionpoint(D--M,A--C);

// Las líneas
draw(A -- B -- C -- D -- cycle);
draw(A -- C);
draw(D -- M);

// Marcamos los puntos
pen FormatoTexto=black+fontsize(10pt);
pen FormatoPunto=3bp+black;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
dot(M,FormatoPunto);
dot(P,FormatoPunto);
label("A",A,SW,FormatoTexto);
label("B",B,SE,FormatoTexto);
label("C",C,NE,FormatoTexto);
label("D",D,NW,FormatoTexto);
label("M",M,E,FormatoTexto);
label("P",P,N,FormatoTexto);
