//---------------------------------------------------------------
// Fichero:  vector4.asy
// Objetivo: Representar un vector del cuarto cuadrante
// Fecha:    J.10.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// El vector
pair v=(3,-2);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 3, Ymin = -2, Ymax = 0, Extra = 0.25;

// Las componentes
draw(v -- (v.x,0), 0.5bp+gray);
draw(v -- (0,v.y), 0.5bp+gray);
pen FormatoTexto = blue+fontsize(10pt);
label("$v_{1}$",(v.x,0),N,FormatoTexto);
label("$v_{2}$",(0,v.y),W,FormatoTexto);

// Las marcas en los ejes
real Sep=0.05;
pen FormatoMarca=0.5bp+blue;
draw((v.x,Sep) -- (v.x,-Sep), FormatoMarca);
draw((Sep,v.y) -- (-Sep,v.y), FormatoMarca);

// Los ejes de coordenadas
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El vector
dot((0,0), 2.5bp+deepgreen);
draw((0,0) -- v, 1.5bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{v}$",1.1v,blue+fontsize(14pt));

// El módulo
label("$|\vec{v}|$",v/2,SW,blue+fontsize(14pt));
