//---------------------------------------------------------------
// Fichero:  paralelogramo.asy
// Objetivo: Representar el paralelogramo de la suma de dos vectores
// Fecha:    J.10.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Los vectores
pair u=(7,1), v=(2,2), s=u+v;

// Dimensiones de los ejes
real Xmin = min(0,u.x,v.x,s.x), Xmax = max(u.x,v.x,s.x);
real Ymin = min(0,u.y,v.y,s.y), Ymax = max(u.y,v.y,s.y);
real Extra = 0.5;

// El eje de abscisas
draw((Xmin-Extra,0) -- (Xmax+Extra,0),gray);

// El eje de ordenadas
draw((0,Ymin-Extra) -- (0,Ymax+Extra),gray);

// El paralelogramo
draw((0,0) -- u -- s -- v -- (0,0), black);

// Las marcas en los ejes
real Sep=0.075;
pen FormatoMarca=0.5bp+blue;
draw((u.x,Sep) -- (u.x,-Sep), FormatoMarca);
draw((v.x,Sep) -- (v.x,-Sep), FormatoMarca);
draw((s.x,Sep) -- (s.x,-Sep), FormatoMarca);
draw((Sep,u.y) -- (-Sep,u.y), FormatoMarca);
draw((Sep,v.y) -- (-Sep,v.y), FormatoMarca);
draw((Sep,s.y) -- (-Sep,s.y), FormatoMarca);

// Las componentes
pen FormatoTexto = blue+fontsize(6pt);
label("$u_{1}$",(u.x,-0.65),align=up,FormatoTexto);
label("$v_{1}$",(v.x,-0.65),align=up,FormatoTexto);
label("$u_{1}+v_{1}$",(s.x,-0.65),align=up,FormatoTexto);
label("$u_{2}$",(0,u.y),W,FormatoTexto);
label("$v_{2}$",(0,v.y),W,FormatoTexto);
label("$u_{2}+v_{2}$",(0,s.y),W,FormatoTexto);
