//---------------------------------------------------------------
// Fichero:  nadar.asy
// Objetivo: Representar la fuerza de nadar y la de la corriente
// Fecha:    D.13.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// El río
draw((0,0) -- (10,0));
draw((0,4) -- (10,4));

// La persona
real Long=0.4;
filldraw(box((2,Long),(2+Long,2*Long)),gray,black);

// Los vectores
pair Origen=(2+Long/2,1.5*Long);
dot(Origen, 4bp+deepgreen);
dot(Origen, 2bp+deepred);
draw(Origen -- Origen+(0,3.2), 1.25bp+deepgreen,Arrow(HookHead,5pt));
draw(Origen -- Origen+(1,0), 1.25bp+deepgreen,Arrow(HookHead,5pt));
draw(Origen -- Origen+(1,3.2), 1.25bp+deepred,Arrow(HookHead,5pt));

