//---------------------------------------------------------------
// Fichero:  ejemplo6.asy
// Objetivo: Representar un caso de producto de número y vector
// Fecha:    L.14.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Los vectores
pair p=(6,3), v=(3,1.5);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 6, Ymin = 0, Ymax = 3, Extra = 0.25;

// Los ejes de coordenadas
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los vectores
dot((0,0), 5bp+deepgreen);
draw((0,0) -- p, 1.25bp+deepred,Arrow(HookHead,5pt));
draw((0,0) -- v, 2bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0) -- p, 0.75bp+deepred);
dot((0,0), 3bp+deepred);

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(8pt);
label("$\vec{v}$",v,2S,FormatoTexto);
label("$\alpha\vec{v}$",p,2S,FormatoTexto);
