//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Representar un caso de ángulo entre dos vectores
// Fecha:    L.14.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Los vectores
pair u=3*dir(50), v=4*dir(128);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 2, Ymin = 0, Ymax = 3, Extra = 0.25;

// Los ejes de coordenadas
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El ángulo
markangle(radius=5mm, u, (0,0), v, 1.5bp+deepgreen);

// Los vectores
dot((0,0), 3bp+black);
draw((0,0) -- u, 1.25bp+black,Arrow(HookHead,5pt));
draw((0,0) -- v, 1.25bp+black,Arrow(HookHead,5pt));

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(8pt);
label("$\vec{u}$",u+0.3*unit(u),FormatoTexto);
label("$\vec{v}$",v+0.3*unit(v),FormatoTexto);
