//---------------------------------------------------------------
// Fichero:  ejemplo4.asy
// Objetivo: Representar un caso de ángulo entre dos vectores
// Fecha:    L.14.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Los vectores
pair u=5*dir(32), v=3*dir(32);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 5, Ymin = 0, Ymax = 3, Extra = 0.25;

// Los ejes de coordenadas
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// Los vectores
dot((0,0), 5bp+black);
dot((0,0), 3bp+red);
draw((0,0) -- u, 2bp+red,Arrow(HookHead,5pt));
draw((0,0) -- v, 1.25bp+black,Arrow(HookHead,5pt));

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(8pt);
label("$\vec{u}$",u,2S,FormatoTexto);
label("$\vec{v}$",v,2S,FormatoTexto);
