//---------------------------------------------------------------
// Fichero:  resolucion2.asy
// Objetivo: Representar la resolución 2
// Fecha:    M.6.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Definimos los tres puntos del triángulo
pair H=(-1,2), J=(3,-2), K=(10,6);

// El punto medio de HJ
pair M=(H+J)/2;

// El baricentro
pair G=(H+J+K)/3;

// El triángulo
draw(H -- J -- K -- H, black);
draw(M -- K, black);

// Los puntos
pen FormatoPunto = 3bp+black;
dot(H, FormatoPunto);
dot(J, FormatoPunto);
dot(K, FormatoPunto);
dot(M, FormatoPunto);
dot(G, FormatoPunto);
pen FormatoTexto = black+fontsize(12pt);
label("H",H,W,FormatoTexto);
label("J",J,S,FormatoTexto);
label("K",K,NE,FormatoTexto);
label("M",M,SW,FormatoTexto);
label("G",G,NW,FormatoTexto);
