//---------------------------------------------------------------
// Fichero:  ab.asy
// Objetivo: Representar el vector que une dos puntos de una recta
// Fecha:    S.10.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -1, Xmax = 5, Ymin = -1, Ymax = 3, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta
draw((-1,0.5) -- (5,3), 1.5bp+blue);
label("r",(5,2.5),fontsize(10pt));

// Los puntos
pair A=(-1,0.5)+0.3*(6,2.5);
pair B=(-1,0.5)+0.7*(6,2.5);
label("A",A,N,fontsize(6pt));
label("B",B,N,fontsize(6pt));

// El vector de dirección
dot(A, 3bp+deepgreen);
dot(B, 3bp+deepgreen);
draw(A -- B, 1bp+deepgreen,Arrow(HookHead,5pt));
pair Pos=(A+B)/2+0.75S;
label("AB",Pos,fontsize(6pt));
draw(Pos+(-0.35,0.35) -- Pos+(0.35,0.35), 0.5bp+black,Arrow(HookHead,1.5pt));
