//---------------------------------------------------------------
// Fichero:  angulopos.asy
// Objetivo: Representar una recta con ángulo positivo
// Fecha:    D.11.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -1, Xmax = 5, Ymin = -1, Ymax = 3, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta
pair A=(-1,-1), B=(5,3);
draw(A -- B, 1.5bp+blue);
label("r",(2.5,1.7),fontsize(12pt));

// El ángulo
draw((2,0)..(2.1,0.25)..A+0.9(3,2),1bp+orange,ArcArrow(3bp));
label("$\alpha$",(2.4,0.5),fontsize(12pt));
