//---------------------------------------------------------------
// Fichero:  figura3.asy
// Objetivo: Representar la figura 3
// Fecha:    M.13.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -1, Xmax = 6, Ymin = 0, Ymax = 3, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta
pair A=(-1,1), B=(6,3);
draw(A -- B, 1.5bp+blue);
label("r",B,2S,fontsize(12pt));

// El vector de dirección
pair v=0.3(B-A);
dot((0,0), 3bp+deepgreen);
draw((0,0) -- v, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{v}$",1.15v,deepgreen+fontsize(12pt));

// Definimos los puntos
pair O=(0,0), H=A+v, P=A+2.5v;

// El vector HP
pen FormatoTexto=black+fontsize(12pt);
dot(H, 3bp+deepgreen);
draw(H -- P, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\lambda\vec{v}$",(H+P)/2,N,FormatoTexto);

// Los vectores de posición
pen FormatoTexto=black+fontsize(6pt);
draw(O -- H, 1bp+orange,Arrow(HookHead,5pt));
pair Pos=H/2+0.2W;
label("OH",Pos,FormatoTexto);
draw(Pos+(-0.25,0.175) -- Pos+(0.25,0.175), 0.5bp+black,Arrow(HookHead,1.5pt));
draw(O -- P, 1bp+orange,Arrow(HookHead,5pt));
pair Pos=P/2+0.75E;
label("OP",Pos,FormatoTexto);
draw(Pos+(-0.25,0.175) -- Pos+(0.25,0.175), 0.5bp+black,Arrow(HookHead,1.5pt));

// Los puntos
pen FormatoTexto=black+fontsize(10pt);
pair O=(0,0), H=A+v, P=A+2.5v;
dot(O, 3bp+black);
dot(H, 3bp+black);
dot(P, 3bp+black);
label("O",O,NW,FormatoTexto);
label("H",H,N,FormatoTexto);
label("P",P,N,FormatoTexto);
