//---------------------------------------------------------------
// Fichero:  vectores-direccion.asy
// Objetivo: Representar los vectores de dirección de rectas paralelas
// Fecha:    X.28.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -2, Xmax = 6, Ymin = 0, Ymax = 4, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El vector de dirección
dot((0,0), 3bp+deepgreen);
pair v=(3,0.75);
draw((0,0) -- v, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{v}$",1.1v,deepgreen+fontsize(10pt));

// La recta r
pair A=(-2,0.75), AF=A+2.5v;
pair A1=A+0.2v, A2=A+1.5v;
draw(A -- AF, 1.5bp+blue);
label("r",1.05AF,fontsize(12pt));
dot(A1, 3bp+orange);
draw(A1 -- A2, 1.25bp+orange,Arrow(HookHead,5pt));
label("$\vec{v}_r$",(A1+A2)/2,S,orange+fontsize(10pt));

// La recta s
pair A=(-2,1.8), AF=A+2.5v;
pair A1=A+1.2v, A2=A+2.3v;
draw(A -- AF, 1.5bp+blue);
label("s",1.05AF,fontsize(12pt));
dot(A1, 3bp+orange);
draw(A1 -- A2, 1.25bp+orange,Arrow(HookHead,5pt));
label("$\vec{v}_s$",(A1+A2)/2,S,orange+fontsize(10pt));
