//---------------------------------------------------------------
// Fichero:  vectores.asy
// Objetivo: Representar los vectores de rectas perpendiculares
// Fecha:    V.30.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -2, Xmax = 5, Ymin = 0, Ymax = 6, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El vector de dirección de la recta r
dot((0,0), 3bp+deepgreen);
pair v=(1.5,0.9);
draw((0,0) -- v, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{v}_r=\vec{n}_s$",v,N,deepgreen+fontsize(8pt));

// El vector de dirección de la recta s
pair n=(-v.y,v.x);
draw((0,0) -- n, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{v}_s=\vec{n}_r$",n,N,deepgreen+fontsize(8pt));

// La recta r
pair A=(-2,2.3), AF=A+3.8v;
draw(A -- AF, 1.5bp+blue);
label("r",AF,1.5E,fontsize(12pt));

// El punto de intersección
pair V=A+2.7v;

// La recta s
pair A3=V+0.75n, A4=V+(-2.6)*n;
draw(A3 -- A4, 1.5bp+blue);
label("s",A4,E,fontsize(12pt));

// El ángulo recto
markrightangle(A3, V, A, 3mm, 0.75bp+orange);
