//---------------------------------------------------------------
// Fichero:  ejemplo3.asy
// Objetivo: Mostrar el ejemplo 3
// Fecha:    L.2.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 3, Ymin = -3, Ymax = 3, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta dada
draw((-2,Ymin) -- (-2,Ymax), 1.5bp+blue);
label("g",(-2,Ymax),W);

// La recta pedida
draw((Xmin,-1) -- (Xmax,-1), 1.5bp+deepgreen);
label("h",(Xmax,-1),S);

// El punto
dot(Label("D"), (2,-1), S, 5pt+black);
