//---------------------------------------------------------------
// Fichero:  paralelas.asy
// Objetivo: Representar dos rectas paralelas
// Fecha:    X.4.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.3cm);

// Grosor de las líneas
defaultpen(1);

// Las rectas
pair A=(0,0), B=(10,1), C=(0,1), D=(10,2);
draw(A -- B);
draw(C -- D);

// Un punto
dot(Label("P"),C+(D-C)/3,N,3bp+black);

// Los nombres de las rectas
label("$r$", D, E);
label("$s$", B, E);
