//---------------------------------------------------------------
// Fichero:  pendientes.asy
// Objetivo: Representar los ángulos de rectas paralelas
// Fecha:    X.28.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -1, Xmax = 7, Ymin = -1, Ymax = 3, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los vectores de dirección
pair v1=(2,1), v2=(1,1.5);

// La recta r
pair A=(1,0), A1=A-v1, A2=A+2.8v1;
markangle("$\alpha$", radius=10mm, (7,0), A, A2, 0.5bp+orange);
draw(A1 -- A2, 1.5bp+blue);
label("r",A2,E,fontsize(12pt));

// La recta s
pair A=(4,0), A1=A-0.8v2, A2=A+2v2;
markangle("$\beta$", radius=5mm, (7,0), A, A2, 0.5bp+orange);
draw(A1 -- A2, 1.5bp+blue);
label("s",A2,W,fontsize(12pt));
