//---------------------------------------------------------------
// Fichero:  vectores-normales.asy
// Objetivo: Representar los vectores normales de dos rectas secantes
// Fecha:    X.4.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Las rectas
pair A=(0,0), B=(8,4), C=(0,3), D=(8,1);
draw(A -- B);
draw(C -- D);

// Los nombres de las rectas
label("$r$", B, E);
label("$s$", D, E);

// El punto de corte
pair V=intersectionpoint(A--B,C--D);
dot(V, 3bp+deepgreen);

// Los vectores normales
pair dir=B-A;
pair n=(dir.y,-dir.x);
pair F=V+0.2n;
draw(V -- F, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{n}_r$",(V+F)/2,W,deepgreen+fontsize(10pt));

pair dir=C-D;
pair n=(dir.y,-dir.x);
pair F=V+0.2n;
draw(V -- F, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{n}_s$",(V+F)/2,W,deepgreen+fontsize(10pt));
