//---------------------------------------------------------------
// Fichero:  dibujo.asy
// Objetivo: Representar la situación del ejercicio
// Fecha:    V.6.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
pair A=(-4,1), B=(12,-7), C=(-2,-6), D=(0,-5);

// Dimensiones de los ejes
real Xmin = -5, Xmax = 12, Ymin = -7, Ymax = 1, Extra = 0.25;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.25mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Las rectas
pen FormatoTexto = black+fontsize(8pt);
pair vr=B-A;
draw (A-0.05vr -- B+0.05vr,blue);
label("r",A+0.75vr,NE,FormatoTexto);
pair vs=D-C;
draw (C-0.5vs -- D+6vs,blue);
label("s",C+4.5vs,SE,FormatoTexto);

// Los puntos
pen FormatoPunto=2.5pt+black;
dot(Label("A",FormatoTexto), A, NE, FormatoPunto);
dot(Label("B",FormatoTexto), B, NE, FormatoPunto);
dot(Label("C",FormatoTexto), C, S, FormatoPunto);
dot(Label("D",FormatoTexto), D, SE, FormatoPunto);
dot((4,-3), 3bp+deepgreen);

