//---------------------------------------------------------------
// Fichero:  distancia.asy
// Objetivo: Mostrar la distancia entre dos puntos
// Fecha:    V.13.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes
real Xmin = 0, Xmax = 6.3, Ymin = 0, Ymax = 3.3, Extra = 0.25;
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// Los puntos
pair A=(1,1), B=(5,3);
pen FormatoTexto=black+fontsize(10pt);
label("A",A,NW,FormatoTexto);
label("B",B,NW,FormatoTexto);

// La separación entre las flechas y el objeto
real Separacion = 0.25;

// Las flechas que marcan los incrementos
pair C=(B.x,A.y);
draw(A -- C -- B,gray);
draw(A-(0,Separacion) -- C-(0,Separacion), 0.75bp+blue, Bars(1.5mm));
draw(C+(Separacion,0) -- B+(Separacion,0), 0.75bp+blue, Bars(1.5mm));

// Los valores
pen FormatoTexto=black+fontsize(8pt);
label("b$_{1}-$a$_{1}$", (A+C)/2-(0,2*Separacion), FormatoTexto);
label("b$_{2}-$a$_{2}$", (C+B)/2+(4*Separacion,0), FormatoTexto);

// Las marcas de los ejes
draw((A.x,0.05)--(A.x,-0.05),1pt+blue);
label("a$_{1}$",(A.x,0),S,FormatoTexto);
draw((B.x,0.05)--(B.x,-0.05),1pt+blue);
label("b$_{1}$",(B.x,0),S,FormatoTexto);
draw((0.05,A.y)--(-0.05,A.y),1pt+blue);
label("a$_{2}$",(0,A.y),W,FormatoTexto);
draw((0.05,B.y)--(-0.05,B.y),1pt+blue);
label("b$_{2}$",(0,B.y),W,FormatoTexto);

// La distancia
draw(A -- B, 1.25bp+deepgreen);
label("d",(A+B)/2,NW,FormatoTexto);

// Marcamos los puntos
dot(A,3bp+black);
dot(B,3bp+black);
