//---------------------------------------------------------------
// Fichero:  figura1.asy
// Objetivo: Representar la figura1
// Fecha:    S.14.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// La recta
pair A=(0,2), B=(7,0);
draw(A -- B);

// Un punto y su proyección sobre la recta
pair H=(4,3);
pair Q=intersectionpoint(A -- B, H -- H+(-2,-7));

// La distancia
draw(H -- Q, 1.5bp+deepgreen);
label("d",(H+Q)/2,W);

// Otros segmentos
pair D=Q+0.3(B-A);
draw(H -- D, 1.5bp+blue);
label("d$_1$",(H+D)/2,NE);
pair F=Q-0.4(B-A);
draw(H -- F, 1.5bp+blue);
label("d$_2$",(H+F)/2,NW);

// Marcamos los puntos
dot(H,3bp+black);
dot(Q,3bp+black);
dot(D,3bp+black);
dot(F,3bp+black);
