//---------------------------------------------------------------
// Fichero:  dibujo.asy
// Objetivo: Representar la situación
// Fecha:    M.24.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
pair A=(-3,6), B=(7,1), C=(-2,3), H=(-5,-3);

// La altura por C
pair Hr=extension(H,C,A,B);
draw(H -- Hr+unit(Hr-H), blue);
markrightangle(B, Hr, C, 2mm, 0.5bp+orange);

// La altura por B
pair Hs=extension(A,C,H,B);
draw(C -- Hs+unit(Hs-C), gray);
draw(H -- B+unit(B-H), blue);
markrightangle(B, Hs, C, 2mm, 0.5bp+orange);

// El triángulo
draw(A -- B -- C -- cycle);

// Marcamos los puntos
pen FormatoPunto=3bp+black;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(Hr,FormatoPunto);
dot(H,4bp+deepgreen);
pen FormatoTexto=black+fontsize(8pt);
label("A",A,NW,FormatoTexto);
label("B",B,SE,FormatoTexto);
label("C",C,W,FormatoTexto);

// Nombres de las rectas
label("r",Hr+1.5*unit(Hr-H),FormatoTexto);
label("s",(H+B)/2,S,FormatoTexto);
