//---------------------------------------------------------------
// Fichero:  dibujo.asy
// Objetivo: Representar el problema
// Fecha:    M.24.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
pair A=(4,9), V=(-2,3), B=(15,-4);
draw(A -- V -- B);

// La bisectriz
pair Vector=unit(A-V)+unit(B-V);
draw (V -- V+8*Vector, deepgreen);

// Un punto de la bisectriz
pair P=V+5*Vector;

// Distancias de P a las semirrectas
pen FormatoTexto=black+fontsize(8pt);
pair Vr=A-V, Nr=(-Vr.y,Vr.x);
pair Pr=intersectionpoint(V--A,P--P+Nr);
draw(P -- Pr, blue);
markrightangle(V, Pr, P, 2mm, 0.5bp+orange);
label("d(P,r)",(P+Pr)/2,NE,FormatoTexto);
pair Vs=B-V, Ns=(Vs.y,-Vs.x);
pair Ps=intersectionpoint(V--B,P--P+Ns);
draw(P -- Ps, blue);
markrightangle(V, Ps, P, 2mm, 0.5bp+orange);
label("d(P,s)",(P+Ps)/2,SE,FormatoTexto);

// Marcamos los puntos
pen FormatoTexto=black+fontsize(10pt);
pen FormatoPunto=3bp+black;
dot(A,FormatoPunto);
dot(V,FormatoPunto);
dot(B,FormatoPunto);
dot(P,FormatoPunto);
label("A",A,NE,FormatoTexto);
label("V",V,W,FormatoTexto);
label("B",B,SE,FormatoTexto);
label("P",P,SE,FormatoTexto);

// Nombres de las rectas
label("r",(A+V)/2,NW,FormatoTexto);
label("s",(B+V)/2,SW,FormatoTexto);
label("z",V+8.5*Vector,FormatoTexto);
