//---------------------------------------------------------------
// Fichero:  dibujo.asy
// Objetivo: Representar el problema
// Fecha:    J.26.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
pair V=(0,0), A=V+3*(-2,-1), B=V+(11,-2);
draw(A -- V -- B);

// Los vectores
pair VA=3*unit(A-V);
pair VB=3*unit(B-V);
pair Vz=VA+VB;

// La bisectriz
draw(V -- 1.5*Vz,1.5bp+deepgreen);

// Líneas auxiliares
pen Punteado = linetype(new real[] {2,2});
draw(Vz -- VA, Punteado+gray);
draw(Vz -- VB, Punteado+gray);

// Dibujamos los vectores
draw(V -- VA, 1.5bp+blue,Arrow(HookHead,5pt));
draw(V -- VB, 1.5bp+blue,Arrow(HookHead,5pt));
draw(V -- Vz, 1.5bp+blue,Arrow(HookHead,5pt));

// Los nombres de los vectores y la recta
pen FormatoTexto = blue+fontsize(10pt);
label("$\vec{u}_{VA}$",VA/2,NW,FormatoTexto);
label("$\vec{u}_{VB}$",VB/2,NE,FormatoTexto);
label("$\vec{v}_z$",Vz/2,E,FormatoTexto);

// Marcamos los puntos
pen FormatoTexto=black+fontsize(12pt);
pen FormatoPunto=4bp+black;
dot(A,FormatoPunto);
dot(V,FormatoPunto);
dot(B,FormatoPunto);
label("A",A,W,FormatoTexto);
label("V",V,N,FormatoTexto);
label("B",B,E,FormatoTexto);

// El nombre de la recta bisectriz
label("z",1.75*Vz,FormatoTexto);
