//---------------------------------------------------------------
// Fichero:  pertenece.asy
// Objetivo: Recta tangente en un punto que pertenece a la circunferencia
// Fecha:    V.4.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición del centro y el punto de tangencia
pair T=(0,0), G=dir(155);

// Dos puntos de la recta
pair A=G+(-G.y,G.x), B=G+(G.y,-G.x);

// La recta
draw(A -- B, deepgreen);

// La circunferencia
draw(circle(T,1));

// El punto
dot(G, 4bp+blue);
