//---------------------------------------------------------------
// Fichero:  enunciado02.asy
// Objetivo: Ilustrar el enunciado 2
// Fecha:    D.23.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(5.12,0), C=(0,4);

// Los ángulos
pen FormAng=fontsize(12pt)+black;
pen FormArc=0.5bp+black;
markangle(Label("$\hat{B}$",FormAng), radius=12mm, C, B, A, FormArc);
markangle(Label("$52^\circ$",FormAng), radius=8mm, A, C, B, FormArc);
markrightangle(B, A, C, 4mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
pen FormatoTexto=black+fontsize(12pt)+Helvetica(series="b",shape="n");
label("c", (A+B)/2, S, FormatoTexto);
label("a", (B+C)/2, NE, FormatoTexto);
label("4", (A+C)/2, W, FormatoTexto);

// Los puntos
pen FormatoPunto=black+3bp;
dot(Label('A',FormatoTexto), A, SW, FormatoPunto);
dot(Label('B',FormatoTexto), B, SE, FormatoPunto);
dot(Label('C',FormatoTexto), C, N, FormatoPunto);
