//---------------------------------------------------------------
// Fichero:  enunciado10.asy
// Objetivo: Ilustrar el enunciado 10
// Fecha:    D.23.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=12*dir(72), B=(0,0), C=(39,0);

// Los ángulos
pen FormAng=fontsize(12pt)+black;
pen FormArc=0.5bp+black;
markangle(Label("$72^\circ$",FormAng), radius=8mm, C, B, A, FormArc);
markangle(Label("$\hat{C}$",FormAng), radius=16mm, A, C, B, FormArc);
markrightangle(B, A, C, 4mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
pen FormatoTexto=black+fontsize(12pt)+Helvetica(series="b",shape="n");
label("c", (A+B)/2, NW, FormatoTexto);
label("39", (B+C)/2, S, FormatoTexto);
label("b", (A+C)/2, NE, FormatoTexto);

// Los puntos
pen FormatoPunto=black+3bp;
dot(Label('A',FormatoTexto), A, N, FormatoPunto);
dot(Label('B',FormatoTexto), B, W, FormatoPunto);
dot(Label('C',FormatoTexto), C, E, FormatoPunto);
