//---------------------------------------------------------------
// Fichero:  figura2.asy
// Objetivo: Ilustrar la figura 2
// Fecha:    J.6.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle() markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,4cm);

// Grosor de las líneas
defaultpen(1);

// Las circunferencias
pair T1=(-9,0), T2=(6,0);
real R1=9, R2=6;

// Definición de puntos de las circunferencias
real Ang=aCos(0.2);
pair P1=T1+R1*dir(Ang), P2=T1+R1*dir(-Ang);
pair Q1=T2+R2*dir(Ang), Q2=T2+R2*dir(-Ang);

// El formato de texto
pen Formato=black+fontsize(14pt);

// Los ángulos
markangle(Label("$\alpha$",Formato), radius=5mm, P2, T1, P1, 1bp+blue);
markrightangle(Q1, P1, T1, 5mm, 1bp+gray);
markrightangle(Q2, P2, T1, 5mm, 1bp+gray);
markrightangle(P1, Q1, T2, 5mm, 1bp+gray);
markrightangle(P2, Q2, T2, 5mm, 1bp+gray);

// Las circunferencias
draw(circle(T1,R1));
draw(circle(T2,R2));

// Los radios
draw(T1 -- P1, blue);
label("9", (T1+P1)/2, W, blue);
draw(T1 -- P2, blue);
label("9", (T1+P2)/2, W, blue);
draw(T2 -- Q1, blue);
label("6", (T2+Q1)/2, E, blue);
draw(T2 -- Q2, blue);
label("6", (T2+Q2)/2, E, blue);

// Los segmentos tangentes
draw(P1 -- Q1, blue);
draw(P2 -- Q2, blue);

// Los puntos
dot(T1, 3bp+black);
dot(T2, 3bp+black);
dot(P1, 3bp+black);
dot(P2, 3bp+black);
dot(Q1, 3bp+black);
dot(Q2, 3bp+black);
