//---------------------------------------------------------------
// Fichero:  figura6.asy
// Objetivo: Ilustrar la figura 6
// Fecha:    J.6.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,4cm);

// Grosor de las líneas
defaultpen(1);

// El radio de la circunferencia
real R=2.1547;

// El semicírculo base
path Sem=buildcycle(arc((0,0),1,0,180),(-1,0)--(1,0));

// Los semicírculos
for (int i=0 ; i<6 ; ++i)
    { filldraw(rotate(60*i)*shift(1-R,0)*Sem,lightgrey,0.5bp+gray); }

// Los radios
for (int i=0 ; i<6 ; ++i)
    { draw((0,0) -- R*dir(60*i), 0.5bp+blue); }

// La circunferencia
draw(circle((0,0),R));
