//---------------------------------------------------------------
// Fichero:  triangulo.asy
// Objetivo: Representar el triángulo
// Fecha:    D.9.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(-6,0), B=(8,0), C=(-1,12);

// El triangulo
draw(A -- B -- C -- cycle);

// Los vértices
pen FormTex=fontsize(14pt)+black;
pen FormPun=4bp+black;
dot(Label("A",FormTex), A, W, FormPun);
dot(Label("B",FormTex), B, E, FormPun);
dot(Label("C",FormTex), C, N, FormPun);

// La circunferencia inscrita
pair T=(0,4);
draw(circle(T,4));
dot(T, FormPun);

// Los puntos de tangencia
pair T1=(0,0), T2=(-48/13,72/13), T3=(3.2,6.4);
dot(T1, FormPun);
dot(T2, FormPun);
dot(T3, FormPun);

// Los radios de la circunferencia inscrita
draw(T--T1);
draw(T--T2);
draw(T--T3);

// Los lados y los radios
pen FormTex=fontsize(14pt)+blue;
label("a", (B+C)/2, E, FormTex);
label("b", (A+C)/2, W, FormTex);
pen FormTex=fontsize(14pt)+black;
label("6", (-3,0), S, FormTex);
label("8", (4,0), S, FormTex);
label("4", (T+T1)/2, E, FormTex);

// Los ángulos
pen FormAng=fontsize(14pt)+blue;
pen FormArc=1bp+blue;
markangle(Label("$\alpha$",FormAng), radius=5mm, B, A, C, FormArc);
markangle(Label("$\beta$",FormAng), radius=5mm, C, B, A, FormArc);
markangle(Label("$\gamma$",FormAng), radius=5mm, A, C, B, FormArc);

