//---------------------------------------------------------------
// Fichero:  estrella4.asy
// Objetivo: Cuarto paso de la generación de la estrella
// Fecha:    M.11.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// El pentágono
path Penta=polygon(5);

// La estrella
path Estrella;

// Formamos la estrella
for ( int i=0 ; i<=5 ; ++i )
    { Estrella = Estrella -- point(Penta,2*i); }

// Los puntos de la estrella
pair[] Puntos = intersectionpoints(Estrella,Estrella);

// Con esta orden vemos el orden de los puntos para dibujarlos después
//for (int k=0; k<Puntos.length; ++k) dot(format("%i",k),Puntos[k],red);
int Orden[] = {0,1,8,2,3,4,9,5,6,7,0};

// Dibujamos la estrella
for ( int k=0 ; k<Orden.length-1 ; ++k )
    { draw (Puntos[Orden[k]] -- Puntos[Orden[k+1]], blue); }
